import { 
  FileText, 
  Wallet, 
  SearchCheck, 
  RefreshCcw, 
  Send, 
  CheckCircle2 
} from 'lucide-react';
import { OrderStatus, StepConfig } from './types';

export const STEPS: StepConfig[] = [
  {
    key: OrderStatus.ORDER_CREATED,
    label: 'Order created',
    icon: FileText,
    description: 'Order ID #12345'
  },
  {
    key: OrderStatus.AWAITING_DEPOSIT,
    label: 'Awaiting deposit',
    icon: Wallet,
    description: 'Please send funds'
  },
  {
    key: OrderStatus.CONFIRMING,
    label: 'Confirming',
    icon: SearchCheck,
    description: 'Verifying on chain'
  },
  {
    key: OrderStatus.EXCHANGING,
    label: 'Exchanging',
    icon: RefreshCcw,
    description: 'Swapping assets'
  },
  {
    key: OrderStatus.SENDING,
    label: 'Sending',
    icon: Send,
    description: 'Initiating transfer'
  },
  {
    key: OrderStatus.COMPLETED,
    label: 'Completed',
    icon: CheckCircle2,
    description: 'Funds sent'
  },
];

export const PROCESSING_STATUSES = [
  OrderStatus.CONFIRMING,
  OrderStatus.EXCHANGING,
  OrderStatus.SENDING
];

export const ACTION_REQUIRED_STATUSES = [
  OrderStatus.AWAITING_DEPOSIT
];