import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';
import { Check } from 'lucide-react';

export const StepperVariantS: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full pt-4">
        {/* Track Line */}
        <div className="absolute top-10 left-0 w-full h-[2px] bg-slate-800" />
        <div 
          className="absolute top-10 left-0 h-[2px] bg-gradient-to-r from-blue-600 via-purple-500 to-green-400 transition-all duration-700"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isCompleted = index < currentStepIndex;
          const isActive = index === currentStepIndex;

          return (
            <div key={step.key} className="relative z-10 flex flex-col items-center">
              {/* Main Node */}
              <div className="relative w-12 h-12 flex items-center justify-center">
                
                {/* Active: Orbital Ring */}
                {isActive && (
                   <div className="absolute inset-[-4px] rounded-full border border-green-500/30 animate-[spin_3s_linear_infinite]">
                      <div className="absolute top-0 left-1/2 -translate-x-1/2 -translate-y-1/2 w-2 h-2 bg-green-400 rounded-full shadow-[0_0_8px_#4ade80]" />
                   </div>
                )}
                
                {/* Active: Inner Pulse */}
                {isActive && (
                   <div className="absolute inset-0 rounded-full bg-green-500/10 animate-ping" />
                )}

                {/* Node Circle */}
                <div 
                  className={`
                    w-10 h-10 rounded-full flex items-center justify-center transition-all duration-500 border
                    ${isCompleted ? 'bg-gradient-to-br from-green-500 to-green-700 border-transparent text-white shadow-lg shadow-green-900/50' : ''}
                    ${isActive ? 'bg-slate-900 border-green-500 text-green-400 shadow-[0_0_15px_rgba(74,222,128,0.3)]' : ''}
                    ${!isActive && !isCompleted ? 'bg-slate-900 border-slate-700 text-slate-600' : ''}
                  `}
                >
                  {isCompleted ? <Check size={18} /> : <step.icon size={18} />}
                </div>
              </div>

              {/* Text */}
              <div 
                 className={`
                   mt-3 px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-widest border transition-all duration-300
                   ${isActive ? 'bg-green-500/10 border-green-500/50 text-green-400 translate-y-0 opacity-100' : ''}
                   ${isCompleted ? 'border-transparent text-slate-500' : ''}
                   ${!isActive && !isCompleted ? 'border-transparent text-slate-700' : ''}
                 `}
              >
                {step.label}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};