import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';
import { Check } from 'lucide-react';

export const StepperVariantR: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      {/* 
        Kinetic Ring: 
        Based on Variant A structure but emphasizes the "Turning In" animation.
      */}
      <div className="flex w-full items-start justify-between relative">
          
        {/* Background Line */}
        <div className="absolute top-6 left-0 w-full h-1 bg-slate-800 rounded-full" />
        
        {/* Progress Line */}
        <div 
          className="absolute top-6 left-0 h-1 bg-green-500 transition-all duration-500 ease-out rounded-full"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isCompleted = index < currentStepIndex;
          const isActive = index === currentStepIndex;
          
          return (
            <div 
              key={step.key} 
              className="flex flex-col items-center relative z-10"
              style={{ width: `${100 / STEPS.length}%` }}
            >
              {/* Circle Container */}
              <div className="relative flex items-center justify-center w-12 h-12">
                
                {/* 1. Background Circle */}
                <div className={`
                   absolute inset-0 rounded-full border-4 transition-colors duration-300
                   ${isCompleted ? 'bg-green-500 border-green-500' : 'bg-slate-900 border-slate-800'}
                   ${isActive ? 'border-transparent bg-slate-900' : ''} 
                `} />

                {/* 2. Active Spinner Ring ("Turning In") */}
                {isActive && (
                  <div className="absolute inset-0 rounded-full border-4 border-green-500 border-t-transparent border-l-green-500/50 animate-[spin_1s_linear_infinite]" />
                )}

                {/* 3. Icon */}
                <div className={`relative z-10 transition-colors ${isCompleted ? 'text-white' : isActive ? 'text-green-500' : 'text-slate-600'}`}>
                   {isCompleted ? <Check size={20} strokeWidth={3} /> : <step.icon size={20} />}
                </div>

              </div>

              {/* Label */}
              <div className="mt-3 text-center">
                <p 
                  className={`
                    text-xs font-bold uppercase tracking-wider transition-colors duration-300
                    ${isActive ? 'text-green-400' : isCompleted ? 'text-green-600' : 'text-slate-600'}
                  `}
                >
                  {step.label}
                </p>
                {isActive && (
                   <span className="text-[10px] text-green-500/70 font-mono block mt-1">Processing</span>
                )}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};