import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';
import { Check } from 'lucide-react';

export const StepperVariantQ: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      {/* 
        Exchange Standard: 
        - Extremely thin lines.
        - Small, precise dots.
        - Text is highly legible.
        - Active step is highlighted with a subtle ring.
      */}
      <div className="relative flex justify-between w-full pt-2 pb-6">
        {/* Background Track */}
        <div className="absolute top-[9px] left-0 w-full h-[1px] bg-slate-700 z-0" />
        
        {/* Progress Track */}
        <div 
          className="absolute top-[9px] left-0 h-[1px] bg-primary transition-all duration-300 z-0"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isCompleted = index < currentStepIndex;
          const isActive = index === currentStepIndex;

          return (
            <div key={step.key} className="relative z-10 flex flex-col items-center">
              {/* Node */}
              <div 
                className={`
                  w-[18px] h-[18px] rounded-full flex items-center justify-center transition-all duration-300 border-[1.5px]
                  ${isCompleted ? 'bg-primary border-primary text-white' : ''}
                  ${isActive ? 'bg-background border-primary scale-110' : ''}
                  ${!isActive && !isCompleted ? 'bg-background border-slate-600' : ''}
                `}
              >
                {isCompleted && <Check size={10} strokeWidth={4} />}
                {isActive && <div className="w-1.5 h-1.5 rounded-full bg-primary" />}
              </div>

              {/* Active Halo (Exchange Style) */}
              {isActive && (
                <div className="absolute top-[-3px] left-[-3px] w-6 h-6 rounded-full border border-primary/30 animate-ping" />
              )}

              {/* Label */}
              <div 
                 className={`
                   absolute top-6 w-32 text-center text-xs transition-colors duration-300
                   ${isActive ? 'font-bold text-white' : isCompleted ? 'font-medium text-slate-400' : 'text-slate-600'}
                 `}
              >
                {step.label}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};