import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantP: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full p-2 bg-slate-900 rounded-full shadow-[inset_0_2px_4px_rgba(0,0,0,0.6)] border-b border-white/5">
        
        {/* Fill Bar */}
        <div 
           className="absolute top-2 left-2 bottom-2 bg-green-600 rounded-full transition-all duration-500 opacity-20"
           style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isActive = index === currentStepIndex;
          const isCompleted = index < currentStepIndex;

          return (
            <div key={step.key} className="relative z-10 p-2">
              <div 
                className={`
                  w-6 h-6 rounded-full flex items-center justify-center transition-all duration-300
                  ${isCompleted ? 'bg-green-500 shadow-[0_0_10px_rgba(34,197,94,0.5)]' : ''}
                  ${isActive ? 'bg-green-400 ring-4 ring-green-900 animate-pulse' : ''}
                  ${!isActive && !isCompleted ? 'bg-slate-800' : ''}
                `}
              >
                 <div className={`w-2 h-2 rounded-full ${isCompleted || isActive ? 'bg-white' : 'bg-slate-600'}`} />
              </div>
            </div>
          );
        })}
      </div>
      
      <div className="flex justify-between w-full px-2 mt-2">
         {STEPS.map((step, index) => (
             <span key={`lbl-${index}`} className={`text-[10px] w-12 text-center ${index === currentStepIndex ? 'text-green-400 font-bold' : 'text-slate-600'}`}>
                 {step.label}
             </span>
         ))}
      </div>
    </div>
  );
};