import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantO: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="flex justify-between items-center gap-2">
        {STEPS.map((step, index) => {
          const isActive = index === currentStepIndex;
          const isCompleted = index < currentStepIndex;
          const isNext = index === currentStepIndex + 1;

          return (
            <React.Fragment key={step.key}>
              <div 
                className={`
                  flex items-center justify-center px-3 py-1.5 rounded-full border text-xs font-bold transition-all duration-300
                  ${isCompleted ? 'bg-green-900/30 border-green-700 text-green-500' : ''}
                  ${isActive ? 'bg-green-500 text-slate-900 border-green-500 shadow-[0_0_15px_rgba(34,197,94,0.5)] animate-pulse' : ''}
                  ${!isActive && !isCompleted ? 'bg-slate-900 border-slate-800 text-slate-600' : ''}
                `}
              >
                {step.label}
              </div>
              
              {/* Connector */}
              {index !== STEPS.length - 1 && (
                <div 
                  className={`flex-1 h-0.5 transition-colors duration-300 ${isCompleted ? 'bg-green-600' : 'bg-slate-800'}`} 
                />
              )}
            </React.Fragment>
          );
        })}
      </div>
    </div>
  );
};