import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantN: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full items-center">
        {/* Dashed background for future */}
        <div className="absolute left-0 w-full h-px border-t border-dashed border-slate-700 z-0" />
        
        {/* Solid background for past */}
        <div 
           className="absolute left-0 h-px border-t border-solid border-green-500 transition-all duration-500 z-0"
           style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isActive = index === currentStepIndex;
          const isCompleted = index < currentStepIndex;

          return (
            <div key={step.key} className="relative z-10 bg-background px-2">
              <div 
                className={`
                  w-4 h-4 rounded-full border-2 transition-all duration-300
                  ${isCompleted ? 'bg-green-500 border-green-500' : ''}
                  ${isActive ? 'bg-background border-green-400 scale-150 animate-[spin_3s_linear_infinite]' : ''}
                  ${!isActive && !isCompleted ? 'border-slate-700 bg-background' : ''}
                `}
              >
                  {/* Dashed border effect for active node */}
                  {isActive && (
                      <div className="absolute inset-0 rounded-full border border-dashed border-green-500 animate-spin" />
                  )}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};