import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantM: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full pb-4 border-b border-slate-800">
        
        {/* Active Underline Moving Bar */}
        <div 
          className="absolute bottom-0 h-0.5 bg-green-500 transition-all duration-500 ease-in-out"
          style={{ 
             left: `${(currentStepIndex / STEPS.length) * 100}%`,
             width: `${100 / STEPS.length}%`
          }}
        >
            <div className="w-full h-full bg-green-400 blur-[2px]" />
        </div>

        {STEPS.map((step, index) => {
          const isActive = index === currentStepIndex;
          const isCompleted = index < currentStepIndex;

          return (
            <div key={step.key} className="flex-1 flex flex-col items-center">
              <div 
                className={`
                  text-xs font-bold uppercase tracking-wider mb-2 transition-colors
                  ${isActive ? 'text-green-400 animate-pulse' : isCompleted ? 'text-green-700' : 'text-slate-600'}
                `}
              >
                {step.label}
              </div>
              <div 
                 className={`
                   w-2 h-2 rounded-full transition-colors
                   ${isCompleted ? 'bg-green-800' : isActive ? 'bg-green-400' : 'bg-slate-800'}
                 `} 
              />
            </div>
          );
        })}
      </div>
    </div>
  );
};