import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantL: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full p-4 bg-white/5 rounded-2xl border border-white/10 backdrop-blur-sm">
        <div className="absolute top-1/2 left-4 right-4 h-0.5 bg-white/10 -translate-y-1/2" />
        
        {/* Progress Line */}
        <div 
          className="absolute top-1/2 left-4 h-0.5 bg-green-400 transition-all duration-500 -translate-y-1/2"
          style={{ width: `calc(${(currentStepIndex / (STEPS.length - 1)) * 100}% - 2rem)` }}
        />

        {STEPS.map((step, index) => {
          const isActive = index === currentStepIndex;
          const isCompleted = index < currentStepIndex;

          return (
            <div key={step.key} className="relative z-10 flex flex-col items-center">
              <div 
                className={`
                  w-12 h-12 rounded-full flex items-center justify-center backdrop-blur-md border transition-all duration-300
                  ${isCompleted ? 'bg-green-500/20 border-green-500 text-green-500' : ''}
                  ${isActive ? 'bg-green-500/10 border-green-400 text-white shadow-[0_0_15px_rgba(74,222,128,0.3)]' : ''}
                  ${!isActive && !isCompleted ? 'bg-white/5 border-white/10 text-slate-500' : ''}
                `}
              >
                 <step.icon size={20} className={isActive ? 'animate-pulse' : ''} />
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};