import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantK: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full">
        <div className="absolute top-1/2 left-0 w-full h-px bg-slate-700 -translate-y-1/2" />
        <div 
          className="absolute top-1/2 left-0 h-px bg-green-500 transition-all duration-500 -translate-y-1/2"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isActive = index === currentStepIndex;
          const isCompleted = index < currentStepIndex;

          return (
            <div key={step.key} className="relative z-10">
              <div 
                className={`
                  w-6 h-6 rotate-45 border-2 transition-all duration-300 flex items-center justify-center
                  ${isCompleted ? 'bg-green-500 border-green-500' : ''}
                  ${isActive ? 'bg-slate-900 border-green-400 scale-125' : ''}
                  ${!isActive && !isCompleted ? 'bg-slate-900 border-slate-700' : ''}
                `}
              >
                {isActive && <div className="w-2 h-2 bg-green-400 animate-ping" />}
              </div>
              
              <div className={`absolute left-1/2 -translate-x-1/2 mt-4 text-[10px] font-bold uppercase tracking-wider whitespace-nowrap ${isActive ? 'text-green-400' : 'text-slate-600'}`}>
                {step.label}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};