import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantJ: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative h-4 bg-slate-800 rounded-full w-full">
        <div 
          className="absolute top-0 left-0 h-full bg-gradient-to-r from-emerald-600 to-green-400 rounded-full transition-all duration-500"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        >
             {/* Glowing leading edge */}
             <div className="absolute right-0 top-0 h-full w-4 bg-white/50 blur-sm rounded-full animate-pulse" />
        </div>

        <div className="absolute top-0 left-0 w-full h-full flex justify-between px-[2px] items-center">
          {STEPS.map((step, index) => {
            const isActive = index === currentStepIndex;
            const isCompleted = index <= currentStepIndex;

            return (
              <div key={step.key} className="relative flex flex-col items-center">
                <div 
                  className={`
                    w-2 h-2 rounded-full transition-colors duration-300
                    ${isCompleted ? 'bg-white' : 'bg-slate-600'}
                    ${isActive ? 'scale-150 shadow-[0_0_10px_white]' : ''}
                  `}
                />
                {isActive && (
                  <div className="absolute top-6 w-max text-xs font-bold text-green-400 bg-slate-900/80 px-2 py-1 rounded border border-green-500/30 animate-bounce">
                    {step.label}
                  </div>
                )}
              </div>
            );
          })}
        </div>
      </div>
    </div>
  );
};