import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';

export const StepperVariantI: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full pt-2">
        {/* Line */}
        <div className="absolute top-3 left-0 w-full h-[2px] bg-slate-800 -z-10" />
        <div 
          className="absolute top-3 left-0 h-[2px] bg-emerald-500 transition-all duration-500 -z-10"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isActive = index === currentStepIndex;
          const isCompleted = index < currentStepIndex;

          return (
            <div key={step.key} className="flex flex-col items-center gap-3">
              <div className="relative flex items-center justify-center">
                <div 
                  className={`
                    w-3 h-3 rounded-full transition-all duration-300
                    ${isCompleted ? 'bg-emerald-500' : ''}
                    ${isActive ? 'bg-white ring-4 ring-emerald-500/30 ring-offset-2 ring-offset-slate-900 animate-[pulse_1.5s_ease-in-out_infinite]' : ''}
                    ${!isActive && !isCompleted ? 'bg-slate-700' : ''}
                  `}
                />
              </div>
              <span className={`text-xs font-medium ${isActive ? 'text-emerald-400' : 'text-slate-500'}`}>
                {step.label}
              </span>
            </div>
          );
        })}
      </div>
    </div>
  );
};