import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';
import { Check } from 'lucide-react';

export const StepperVariantH: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full items-center">
        {/* Track */}
        <div className="absolute top-1/2 left-0 w-full h-1 bg-slate-800 -translate-y-1/2 z-0" />
        <div 
          className="absolute top-1/2 left-0 h-1 bg-green-600 transition-all duration-500 -translate-y-1/2 z-0"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isCompleted = index < currentStepIndex;
          const isActive = index === currentStepIndex;

          return (
            <div key={step.key} className="relative z-10 flex flex-col items-center group">
              <div 
                className={`
                  w-8 h-8 flex items-center justify-center transform transition-all duration-300
                  ${isCompleted ? 'bg-green-600 text-white' : ''}
                  ${isActive ? 'bg-slate-900 border-2 border-green-500 text-green-500 scale-125' : ''}
                  ${!isActive && !isCompleted ? 'bg-slate-800 text-slate-500' : ''}
                `}
                style={{ borderRadius: '4px' }} // Subtle rounding, mostly square
              >
                {/* Inner Blinking Square for Active */}
                {isActive && (
                  <div className="absolute inset-1 bg-green-500/20 animate-ping rounded-sm" />
                )}
                {isCompleted ? <Check size={14} /> : <div className="w-2 h-2 bg-current rounded-sm" />}
              </div>
              <span className={`mt-2 text-xs font-medium uppercase tracking-wider ${isActive ? 'text-green-500 animate-pulse' : 'text-slate-600'}`}>
                {step.label.split(' ')[0]}
              </span>
            </div>
          );
        })}
      </div>
    </div>
  );
};