import React from 'react';
import { StepperProps } from '../types';
import { STEPS } from '../constants';
import { Check } from 'lucide-react';

export const StepperVariantG: React.FC<StepperProps> = ({ status, className = '' }) => {
  const currentStepIndex = STEPS.findIndex((s) => s.key === status);

  return (
    <div className={`w-full ${className}`}>
      <div className="relative flex justify-between w-full">
        {/* Background Line */}
        <div className="absolute top-1/2 left-0 w-full h-0.5 bg-slate-800 -translate-y-1/2 z-0" />
        
        {/* Active Line (Glowing) */}
        <div 
          className="absolute top-1/2 left-0 h-0.5 bg-green-500 shadow-[0_0_10px_#22c55e] transition-all duration-500 -translate-y-1/2 z-0"
          style={{ width: `${(currentStepIndex / (STEPS.length - 1)) * 100}%` }}
        />

        {STEPS.map((step, index) => {
          const isCompleted = index < currentStepIndex;
          const isActive = index === currentStepIndex;
          
          return (
            <div key={step.key} className="relative z-10 flex flex-col items-center">
              <div 
                className={`
                  w-10 h-10 rounded-full flex items-center justify-center border-2 bg-slate-950 transition-all duration-300
                  ${isCompleted ? 'border-green-500 text-green-500 shadow-[0_0_15px_rgba(34,197,94,0.4)]' : ''}
                  ${isActive ? 'border-green-400 text-green-400 shadow-[0_0_20px_rgba(74,222,128,0.8)] animate-pulse' : ''}
                  ${!isActive && !isCompleted ? 'border-slate-800 text-slate-700' : ''}
                `}
              >
                {isCompleted ? <Check size={18} /> : <step.icon size={18} />}
              </div>
              
              {isActive && (
                <div className="absolute -bottom-6 text-[10px] font-mono text-green-400 uppercase tracking-widest animate-pulse">
                  Active
                </div>
              )}
            </div>
          );
        })}
      </div>
    </div>
  );
};